/*
 * Decompiled with CFR 0.152.
 */
package atomicActions;

import atomicActions.AtomicActions;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import decisionMakingSystem.Action;
import decisionMakingSystem.AffordanceType;
import decisionMakingSystem.DecisionModuleImpl;
import decisionMakingSystem.EItem;
import decisionMakingSystem.ItemCathegory;
import episodicbot.EpisBot;
import java.io.Serializable;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class AtomicAction
implements Serializable {
    public AtomicActions type = null;
    public int counter = 0;
    public int actionStart = 0;
    public transient EpisBot agent = null;
    protected Action parent = null;
    public transient DecisionModuleImpl dModule = null;
    public Location location = null;
    private boolean logged = false;

    public AtomicAction() {
    }

    public AtomicAction(Action parent, EpisBot agent) {
        this.agent = agent;
        this.parent = parent;
    }

    AtomicAction(AtomicActions type) {
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Location getThePlace() {
        HashMap<AffordanceType, EItem> hashMap = this.parent.satisfyingItems;
        synchronized (hashMap) {
            if (this.parent.satisfyingItems != null) {
                for (EItem item : this.parent.satisfyingItems.values()) {
                    if (item == null || !item.cathegory.equals((Object)ItemCathegory.PLACE)) continue;
                    return item.getLocation();
                }
            }
        }
        return new Location(0.0, 0.0, 0.0);
    }

    public boolean checkIfOnThePlace() {
        if (this.location == null) {
            this.location = this.getThePlace();
        }
        if (this.location.equals(new Location(0.0, 0.0, 0.0))) {
            return true;
        }
        if (this.agent.getLocation() != null && this.agent.getLocation().getDistance(this.location) < 505.0) {
            return true;
        }
        this.agent.safeRunToLocation(this.location);
        return false;
    }

    public void execute() {
        if (this.counter == 0) {
            this.initialisation();
        }
        this.counter = this.agent.getCurrentTime();
    }

    public boolean succeeded() {
        return false;
    }

    public boolean failed() {
        return this.counter - this.actionStart > this.parent.timeLimit;
    }

    protected void initialisation() {
        this.agent.getAct().act(new Configuration().setAction(this.type.toString()).setName(this.type.toString()));
    }

    public void terminalisation() {
    }

    public boolean equals(Object obj) {
        String obj2;
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        AtomicAction tmp = (AtomicAction)obj;
        String obj1 = this.type.name() + this.counter + this.location + this.parent.toString();
        return obj1.equals(obj2 = this.type.name() + this.counter + this.location + this.parent.toString());
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 37 * hash + (this.parent != null ? this.parent.hashCode() : 0);
        hash = 37 * hash + (this.location != null ? this.location.hashCode() : 0);
        return hash;
    }

    public String toString() {
        String result = this.type.name() + " | " + this.parent.name + " | " + this.counter;
        return result;
    }

    public void logFinished(String text) {
        if (!this.logged) {
            this.agent.getLogger().user().info(text);
        }
        this.logged = true;
    }
}

