/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.storyworld.runtime;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.exceptions.PogamutRuntimeException;
import cz.cuni.amis.pogamut.ut2004.storyworld.place.SPStoryWorld;
import cz.cuni.amis.utils.symbols.SPSymbol;
import cz.cuni.amis.utils.symbols.SPSymbolMap;
import java.io.FileNotFoundException;
import java.util.Random;
import java.util.logging.Logger;

public class StoryWorldRuntime {
    private static StoryWorldRuntime instance = null;
    private SPSymbolMap symbolMap = SPSymbolMap.instance;
    private Random random = new Random(System.currentTimeMillis());
    private SPStoryWorld sw = null;

    public SPStoryWorld getStoryWorld() {
        if (StoryWorldRuntime.instance.sw == null) {
            throw new PogamutRuntimeException("Cannot get instance. Singleton wasn't initialize yet!", (Object)this);
        }
        return this.sw;
    }

    public Random getRandom() {
        return this.random;
    }

    private StoryWorldRuntime() {
    }

    private StoryWorldRuntime(String xmlDefinitionFile, IWorldView ww, Logger log) {
        try {
            this.sw = new SPStoryWorld(xmlDefinitionFile, ww, log);
        }
        catch (FileNotFoundException e) {
            throw new PogamutRuntimeException("File not found: " + xmlDefinitionFile, (Object)e);
        }
    }

    public SPSymbol getSymbol(String symbol) {
        return this.symbolMap.get(symbol);
    }

    public SPSymbolMap getSymbolMap() {
        return this.symbolMap;
    }

    public static StoryWorldRuntime createInstance(String xmlDefinitionFile, IWorldView ww, Logger log) {
        if (instance == null) {
            instance = new StoryWorldRuntime(xmlDefinitionFile, ww, log);
            return instance;
        }
        return instance;
    }

    public static StoryWorldRuntime getInstance() {
        if (instance == null && instance == null) {
            instance = new StoryWorldRuntime();
            return instance;
        }
        return instance;
    }
}

