/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.server;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.AgentState;
import cz.cuni.amis.pogamut.base.agent.AgentStateType;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.communication.commands.IAct;
import cz.cuni.amis.pogamut.base.communication.commands.ICommandSerializer;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.IStartableWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.server.AbstractWorldServer;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.ut2004.bot.IUTAgent;
import cz.cuni.amis.pogamut.ut2004.bot.NativeBotAdapter;
import cz.cuni.amis.pogamut.ut2004.bot.jmx.BotJMXProxy;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.AddBot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.ChangeMap;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.GetMaps;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.PasswordReply;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Ready;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.MapList;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Mutator;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Password;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.translator.events.MapPointListObtained;
import cz.cuni.amis.pogamut.ut2004.communication.translator.events.PlayerListObtained;
import cz.cuni.amis.pogamut.ut2004.communication.translator.events.ReadyCommandRequest;
import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.pogamut.ut2004.server.exceptions.MapChangeException;
import cz.cuni.amis.utils.collections.CollectionEventListener;
import cz.cuni.amis.utils.collections.ObservableCollection;
import cz.cuni.amis.utils.collections.TranslatedObservableCollection;
import cz.cuni.amis.utils.collections.adapters.WVVisibleObjectsSetAdapter;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.FlagListener;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@AgentScoped
public abstract class AbstractUT2004Server<WORLD_VIEW extends IStartableWorldView>
extends AbstractWorldServer<WORLD_VIEW, IUTAgent>
implements IUT2004Server {
    ObservableCollection<Player> players = null;
    List<Mutator> mutators = null;
    Flag<Double> gameSpeed = new Flag();
    List<MapList> maps = null;
    Flag<String> mapName = new Flag();
    ObservableCollection<NativeBotAdapter> nativeAgents = null;
    ObservableCollection<IUTAgent> agents = null;
    private String desiredPassword = null;
    private IWorldEventListener<PlayerListObtained> playerListObtainedListener = new IWorldEventListener<PlayerListObtained>(){

        public void notify(PlayerListObtained event) {
            AbstractUT2004Server.this.players.addAll(event.getPlayers());
        }
    };
    private IWorldEventListener<MapPointListObtained> mapPointListObtainedListener = new IWorldEventListener<MapPointListObtained>(){

        public void notify(MapPointListObtained event) {
            AbstractUT2004Server.this.getAct().act((CommandMessage)new GetMaps());
        }
    };
    private IWorldEventListener<ReadyCommandRequest> readyCommandRequestListener = new IWorldEventListener<ReadyCommandRequest>(){

        public void notify(ReadyCommandRequest event) {
            AbstractUT2004Server.this.setAgentState(AgentStateType.INIT, "GameBots2004 greeted us, adding custom listeners onto the worldview");
            AbstractUT2004Server.this.setAgentStateDescription("Calling prePrepareServer()");
            AbstractUT2004Server.this.prePrepareServer();
            AbstractUT2004Server.this.setAgentStateDescription("prePrepareServer() finished, sending READY");
            AbstractUT2004Server.this.readyCommandRequested();
            AbstractUT2004Server.this.setAgentStateDescription("READY sent.");
        }
    };
    private PasswordReply passwordReply = null;
    private IWorldEventListener<Password> passwordRequestedListener = new IWorldEventListener<Password>(){

        public void notify(Password event) {
            AbstractUT2004Server.this.setAgentStateDescription("Password requested by the world.");
            AbstractUT2004Server.this.passwordReply = AbstractUT2004Server.this.createPasswordReply();
            if (AbstractUT2004Server.this.passwordReply == null) {
                AbstractUT2004Server.this.passwordReply = new PasswordReply("");
            }
            AbstractUT2004Server.this.getLogger().platform().info("Password required for the world, replying with '" + AbstractUT2004Server.this.passwordReply.getPassword() + "'.");
            AbstractUT2004Server.this.getAct().act((CommandMessage)AbstractUT2004Server.this.passwordReply);
        }
    };
    private GameInfo gameInfo = null;
    private IWorldEventListener<GameInfo> gameInfoListener = new IWorldEventListener<GameInfo>(){

        public void notify(GameInfo event) {
            AbstractUT2004Server.this.gameInfo = event;
            AbstractUT2004Server.this.mapName.setFlag((Object)event.getLevel());
        }
    };

    @Inject
    public AbstractUT2004Server(AgentLogger logger, WORLD_VIEW worldView, ICommandSerializer commandSerializer) {
        super(logger, worldView, commandSerializer);
        this.getWorldView().addEventListener(ReadyCommandRequest.class, this.readyCommandRequestListener);
        this.getWorldView().addEventListener(Password.class, this.passwordRequestedListener);
        this.getWorldView().addEventListener(GameInfo.class, this.gameInfoListener);
        this.getWorldView().addEventListener(PlayerListObtained.class, this.playerListObtainedListener);
        this.getWorldView().addEventListener(MapPointListObtained.class, this.mapPointListObtainedListener);
        this.players = new WVVisibleObjectsSetAdapter(Player.class, this.getWorldView());
        this.players.addCollectionListener((CollectionEventListener)new CollectionEventListener<Player>(){
            private Logger logger = Logger.getLogger("PLAYER LIST");

            private void print(String text, Collection<Player> list) {
                this.logger.severe(text);
                for (Player pl : list) {
                    this.logger.severe(" * " + pl.getName());
                }
            }

            public void preAddEvent(Collection<Player> toBeAdded, Collection<Player> whereToAdd) {
                this.print("preAddEvent", toBeAdded);
            }

            public void postAddEvent(Collection<Player> alreadyAdded, Collection<Player> whereWereAdded) {
                this.print("postAddEvent", alreadyAdded);
            }

            public void preRemoveEvent(Collection<Player> toBeRemoved, Collection<Player> whereToRemove) {
                this.print("preRemoveEvent", toBeRemoved);
            }

            public void postRemoveEvent(Collection<Player> alreadyAdded, Collection<Player> whereWereRemoved) {
                this.print("postRemoveEvent", alreadyAdded);
            }
        });
    }

    public void setPassword(String password) {
        this.desiredPassword = password;
    }

    protected abstract void prePrepareServer();

    protected void readyCommandRequested() {
        this.getAct().act((CommandMessage)new Ready());
    }

    public void start() throws AgentException {
        try {
            final CountDownLatch latch = new CountDownLatch(1);
            FlagListener<AgentState> okListener = new FlagListener<AgentState>(){

                public void flagChanged(AgentState changedValue) {
                    if (changedValue.getType().isOKState()) {
                        latch.countDown();
                    }
                }
            };
            this.getAgentState().addListener((FlagListener)okListener);
            super.start();
            latch.await();
        }
        catch (InterruptedException ex) {
            throw new AgentException("Interrupted waiting for initialization.", (Object)ex);
        }
    }

    public PasswordReply getPasswordReply() {
        return this.passwordReply;
    }

    protected PasswordReply createPasswordReply() {
        return this.desiredPassword != null ? new PasswordReply(this.desiredPassword) : null;
    }

    public GameInfo getGameInfo() {
        return this.gameInfo;
    }

    public WORLD_VIEW getWorldView() {
        return (WORLD_VIEW)super.getWorldView();
    }

    public void pause() throws AgentException {
    }

    public void resume() throws AgentException {
    }

    @Override
    public Collection<MapList> getAvailableMaps() {
        return this.maps;
    }

    @Override
    public Flag<Double> getGameSpeedFlag() {
        return this.gameSpeed;
    }

    @Override
    public ImmutableFlag<String> getMapFlag() {
        return this.mapName.getImmutable();
    }

    @Override
    public ObservableCollection<Player> getPlayers() {
        return this.players;
    }

    @Override
    public void setGameMap(String map) throws MapChangeException {
        this.getAct().act((CommandMessage)new ChangeMap(map));
    }

    @Override
    public List<Mutator> getMutators() {
        return this.mutators;
    }

    public ObservableCollection<IUTAgent> getAgents() {
        if (this.getPlayers() == null) {
            return null;
        }
        this.agents = new TranslatedObservableCollection<IUTAgent, Player>(this.getPlayers()){

            protected IUTAgent translate(Player obj) {
                if (obj.getJmx() != null) {
                    try {
                        return new BotJMXProxy(obj.getJmx());
                    }
                    catch (Exception ex) {
                        Logger.getLogger(AbstractUT2004Server.class.getName()).log(Level.SEVERE, "JMX error", ex);
                        throw new RuntimeException(ex);
                    }
                }
                return null;
            }

            protected Object getKeyForObj(Player elem) {
                return elem.getId();
            }
        };
        return this.agents;
    }

    @Override
    public ObservableCollection<NativeBotAdapter> getNativeAgents() {
        if (this.getPlayers() == null) {
            return null;
        }
        this.nativeAgents = new TranslatedObservableCollection<NativeBotAdapter, Player>(this.getPlayers()){

            protected NativeBotAdapter translate(Player obj) {
                if (obj.getJmx() == null) {
                    try {
                        return new NativeBotAdapter(AbstractUT2004Server.this, obj, (IAct)AbstractUT2004Server.this.getAct(), (IWorldView)AbstractUT2004Server.this.getWorldView());
                    }
                    catch (Exception ex) {
                        Logger.getLogger(AbstractUT2004Server.class.getName()).log(Level.SEVERE, "JMX error", ex);
                        throw new RuntimeException(ex);
                    }
                }
                return null;
            }

            protected Object getKeyForObj(Player elem) {
                return elem.getId();
            }
        };
        return this.nativeAgents;
    }

    @Override
    public void connectNativeBot(String botName, String botType) {
        this.getAct().act((CommandMessage)new AddBot(botName, null, null, 3, botType));
    }
}

