/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor;

import cz.cuni.amis.pogamut.base.exceptions.PogamutRuntimeException;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.GeneralDescriptorFactory;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.ItemDescriptor;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.ItemTyped;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.WeaponDescriptorFactory;
import java.util.HashMap;

public class ItemTranslator {
    private HashMap<ItemType, ItemDescriptor> descriptors = new HashMap();
    private static ItemTranslator instance = new ItemTranslator();

    private ItemTranslator() {
    }

    public static ItemTranslator getInstance() {
        return instance;
    }

    public ItemType[] getItemTypes() {
        return this.descriptors.values().toArray(new ItemType[0]);
    }

    public ItemDescriptor getDescriptor(ItemTyped msg) {
        return this.getDescriptor(msg.getType());
    }

    public ItemDescriptor getDescriptor(ItemType type) {
        return this.descriptors.get(type);
    }

    protected ItemDescriptor getOtherDescriptor(ItemTyped message) {
        return GeneralDescriptorFactory.getInstance().getNewDescriptor(message);
    }

    public void createDescriptor(ItemTyped message) {
        switch (message.getType().getCategory()) {
            case AMMO: {
                return;
            }
            case ARMOR: {
                return;
            }
            case OTHER: {
                if (message.getType().getGroup() == ItemType.Group.OTHER) {
                    this.descriptors.put(message.getType(), this.getOtherDescriptor(message));
                } else {
                    this.descriptors.put(message.getType(), this.getOtherDescriptor(message));
                }
                return;
            }
            case HEALTH: {
                return;
            }
            case ADRENALINE: {
                return;
            }
            case WEAPON: {
                this.descriptors.put(message.getType(), WeaponDescriptorFactory.getInstance().getNewDescriptor(message));
                return;
            }
        }
        throw new PogamutRuntimeException("should not reach here - new ItemType.Category has been added and not handled inside the ItemTranslator, item type = " + message.getType(), (Object)this);
    }
}

