/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.translator.bot;

import cz.cuni.amis.fsm.FSMState;
import cz.cuni.amis.fsm.FSMTransition;
import cz.cuni.amis.fsm.IFSMState;
import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldChangeEvent;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemListEnd;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemListStart;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.translator.TranslatorContext;
import cz.cuni.amis.pogamut.ut2004.communication.translator.bot.HandshakeControllerState;
import cz.cuni.amis.pogamut.ut2004.communication.translator.bot.support.BotListState;
import cz.cuni.amis.pogamut.ut2004.communication.translator.events.MapPointListObtained;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FSMState(map={@FSMTransition(state=HandshakeControllerState.class, symbol={ItemListEnd.class}, transition={})})
public class ItemListState
extends BotListState<Item, TranslatorContext> {
    public ItemListState() {
        super(ItemListStart.class, Item.class, ItemListEnd.class);
    }

    @Override
    public void stateLeaving(TranslatorContext translatorContext, IFSMState<InfoMessage, TranslatorContext> toState, InfoMessage symbol) {
        this.processNavPointsAndItems(translatorContext.getNavPoints(), this.getList(), translatorContext);
        this.newList();
    }

    private void processNavPointsAndItems(Map<UnrealId, NavPoint> origNavPoints, List<Item> list, TranslatorContext context) {
        HashMap<UnrealId, Item> items = new HashMap<UnrealId, Item>();
        for (Item item : list) {
            items.put(item.getId(), item);
        }
        context.setItems(items);
        context.processNavPointsAndItems();
        context.getLogger().fine("Pushing NavPoint / Item events.");
        context.getEventQueue().pushEvent(context.getNavPoints().values().toArray(new IWorldChangeEvent[0]));
        context.getEventQueue().pushEvent(context.getItems().values().toArray(new IWorldChangeEvent[0]));
        context.getEventQueue().pushEvent((IWorldChangeEvent)new MapPointListObtained(context.getNavPoints(), context.getItems()));
    }
}

