/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.itemtranslator;

import cz.cuni.amis.pogamut.ut2004.communication.itemtranslator.GeneralDescriptorFactory;
import cz.cuni.amis.pogamut.ut2004.communication.itemtranslator.ITCMsg;
import cz.cuni.amis.pogamut.ut2004.communication.itemtranslator.ItemClassable;
import cz.cuni.amis.pogamut.ut2004.communication.itemtranslator.ItemDescriptor;
import cz.cuni.amis.pogamut.ut2004.communication.itemtranslator.WeaponDescriptorFactory;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemCategory;
import java.util.HashMap;
import java.util.Iterator;

public class ItemTranslator {
    private HashMap<String, ItemDescriptor> descriptors = new HashMap();
    private String[] availableDescriptors = new String[0];
    private static ItemTranslator instance = new ItemTranslator();

    private ItemTranslator() {
    }

    public static ItemTranslator getInstance() {
        return instance;
    }

    public String[] getItemClasses() {
        if (this.availableDescriptors.length < this.descriptors.keySet().size()) {
            String[] availableDescriptors = new String[this.descriptors.keySet().size()];
            Iterator<String> iterate = this.descriptors.keySet().iterator();
            int i = 0;
            while (iterate.hasNext()) {
                availableDescriptors[i++] = iterate.next();
            }
        }
        return this.availableDescriptors;
    }

    public ItemDescriptor getDescriptor(ItemClassable msg) {
        return this.descriptors.get(msg.getItemClass());
    }

    public void createDescriptor(ITCMsg message) {
        if (message.getItemClass().equals("Weapon")) {
            this.descriptors.put(message.getItemClass(), WeaponDescriptorFactory.getInstance().getNewDescriptor(message));
        }
        this.descriptors.put(message.getItemClass(), GeneralDescriptorFactory.getInstance().getNewDescriptor(message));
    }

    public static void main(String[] args) {
        ItemTranslator translator = ItemTranslator.getInstance();
        ITCMsg message = new ITCMsg(true);
        translator.createDescriptor(message);
        ItemDescriptor descriptor = translator.getDescriptor(message);
        System.out.println("Descriptor for:" + message.getItemClass() + ": " + descriptor.toString());
    }

    public void createDescriptor(ItemCategory symbol) {
    }
}

