/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.bot;

import cz.cuni.amis.introspection.Folder;
import cz.cuni.amis.introspection.IntrospectionException;
import cz.cuni.amis.introspection.Property;
import cz.cuni.amis.pogamut.base.agent.AgentState;
import cz.cuni.amis.pogamut.base.agent.AgentStateType;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.agent.exceptions.CantStartJMXException;
import cz.cuni.amis.pogamut.base.agent.exceptions.JMXAlreadyEnabledException;
import cz.cuni.amis.pogamut.base.communication.commands.IAct;
import cz.cuni.amis.pogamut.base.communication.exceptions.CommunicationException;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.exceptions.PogamutException;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.ILogCategories;
import cz.cuni.amis.pogamut.base.utils.logging.ILogPublisher;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Velocity;
import cz.cuni.amis.pogamut.ut2004.bot.IUTAgent;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Kick;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Respawn;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeBotAdapter
implements IUTAgent {
    protected Player player = null;
    protected IUT2004Server server = null;
    IAct act;
    IWorldView worldView = null;
    ConfigChange config = null;
    Flag<AgentState> state = new Flag((Object)new AgentState(AgentStateType.RUNNING, "Native bot is running."));
    private AgentLogger logger = new AgentLogger(){
        private LogCategory single = new LogCategory("default");
        private ILogCategories categories = new ILogCategories(){

            public boolean hasCategory(String name) {
                return false;
            }

            public Map<String, LogCategory> getCategories() {
                return new HashMap<String, LogCategory>();
            }

            public String[] getCategoryNames() {
                return new String[0];
            }

            public String[] getCategoryNamesSorted() {
                return new String[0];
            }

            public LogCategory getCategory(String name) {
                return null;
            }

            public void setLevel(Level newLevel) {
            }
        };

        public LogCategory getCategory(String name) {
            return this.single;
        }

        public ILogCategories getCategories() {
            return this.categories;
        }

        public LogCategory in() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public LogCategory out() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public LogCategory user() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public LogCategory platform() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void addConsoleHandlersToAllCategories() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void addPublisherToAllCategories(ILogPublisher logPublisher) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void addHandlerToAllCategories(Handler handler) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setLevel(Level newLevel) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void enableJMX(MBeanServer mBeanServer, ObjectName parent) throws JMXAlreadyEnabledException, CantStartJMXException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    };
    private Folder folder = new Folder("empty"){
        private Folder[] subfolders;
        private Property[] properties;
        {
            this.subfolders = new Folder[0];
            this.properties = new Property[0];
        }

        public Folder[] getFolders() throws IntrospectionException {
            return this.subfolders;
        }

        public Property[] getProperties() throws IntrospectionException {
            return this.properties;
        }
    };

    public NativeBotAdapter(IUT2004Server server, Player player, IAct act, IWorldView worldView) {
        this.player = player;
        this.server = server;
        this.act = act;
        this.worldView = worldView;
    }

    public IAct getAct() {
        throw new UnsupportedOperationException("Native bots cannot be controled from Java.");
    }

    public String getName() {
        return this.player.getName();
    }

    public String getDisplayName() {
        return this.player.getName();
    }

    public AgentLogger getLogger() {
        return this.logger;
    }

    public ImmutableFlag<AgentState> getAgentState() {
        return this.state.getImmutable();
    }

    public void start() throws AgentException {
        throw new UnsupportedOperationException("Native bot is allways already started.");
    }

    public void pause() throws AgentException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void resume() throws AgentException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void stop() {
        try {
            this.act.act((CommandMessage)new Kick(this.player.getId()));
        }
        catch (CommunicationException ex) {
            throw new RuntimeException("Error during terminating native bot.", ex);
        }
    }

    public void kill() {
        this.stop();
    }

    public Folder getFolder() {
        return this.folder;
    }

    public Location getLocation() {
        return this.player.getLocation();
    }

    public Velocity getVelocity() {
        return this.player.getVelocity();
    }

    public Rotation getRotation() {
        return this.player.getRotation();
    }

    @Override
    public void respawn() throws PogamutException {
        this.act.act((CommandMessage)new Respawn(this.player.getId(), null, null));
    }

    @Override
    public void setBoolConfigure(IUTAgent.BoolBotParam param, boolean value) {
        try {
            Configuration configuration = new Configuration();
            configuration.setId(this.player.getId());
            ConfigChange confCh = this.getConfig();
            if (confCh != null) {
                configuration.copy(confCh);
                param.setField(confCh, value);
            }
            param.set((Object)configuration, value);
            this.act.act((CommandMessage)configuration);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean getBoolConfigure(IUTAgent.BoolBotParam param) {
        try {
            ConfigChange confCh = this.getConfig();
            if (confCh != null) {
                return param.get(this.getConfig());
            }
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    protected ConfigChange getConfig() {
        if (this.config == null) {
            for (ConfigChange c : this.worldView.getAll(ConfigChange.class).values()) {
                if (!c.getBotId().equals(this.player.getId())) continue;
                this.config = c;
                break;
            }
        }
        return this.config;
    }
}

