/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation;

import cz.cuni.amis.pogamut.base.agent.navigation.AbstractPathPlanner;
import cz.cuni.amis.pogamut.base.agent.navigation.PathNotConstructable;
import cz.cuni.amis.pogamut.base.communication.commands.IAct;
import cz.cuni.amis.pogamut.base.communication.exceptions.CommunicationException;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.objects.ILocated;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.GetPath;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PathList;
import cz.cuni.amis.pogamut.ut2004.communication.translator.events.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UTAstar
extends AbstractPathPlanner<ILocated, ILocated> {
    IAct commandSerializer = null;
    IWorldView worldView = null;
    String lastPathRequestID = null;
    IWorldEventListener<Path> pathReceivedListener = null;

    public UTAstar(IAct commandSerializer, IWorldView worldView) {
        this.commandSerializer = commandSerializer;
        this.worldView = worldView;
    }

    public List<ILocated> computePath(ILocated from, ILocated to) throws PathNotConstructable {
        try {
            if (this.pathReceivedListener != null) {
                this.worldView.removeEventListener(Path.class, this.pathReceivedListener);
            }
            this.pathReceivedListener = new IWorldEventListener<Path>(){

                public void notify(Path event) {
                    if (event.getPathId().equals(UTAstar.this.lastPathRequestID)) {
                        UTAstar.this.firePathEvent(UTAstar.this.translatePath(event));
                        UTAstar.this.worldView.removeEventListener(Path.class, (IWorldEventListener)this);
                        UTAstar.this.pathReceivedListener = null;
                    }
                }
            };
            this.worldView.addEventListener(Path.class, this.pathReceivedListener);
            this.lastPathRequestID = UUID.randomUUID().toString();
            this.commandSerializer.act((CommandMessage)new GetPath(this.lastPathRequestID, to.getLocation()));
            return null;
        }
        catch (CommunicationException ex) {
            throw new PathNotConstructable("Path request not send because of communication exception.", (Throwable)ex);
        }
    }

    protected List<ILocated> translatePath(Path path) {
        ArrayList<ILocated> translated = new ArrayList<ILocated>();
        for (PathList pathElem : path.getPath()) {
            translated.add((ILocated)this.worldView.getAll(NavPoint.class).get(pathElem.getRouteId()));
        }
        return translated;
    }
}

