/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.communication.commands.IAct;
import cz.cuni.amis.pogamut.base.communication.exceptions.CommunicationException;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.utils.WorldObjectFuture;
import cz.cuni.amis.pogamut.ut2004.agent.module.AgentModule;
import cz.cuni.amis.pogamut.ut2004.bot.AbstractUT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Act;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.AddRay;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRay;
import cz.cuni.amis.utils.flag.Flag;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.vecmath.Vector3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Raycasting
extends AgentModule {
    Map<String, WorldObjectFuture<AutoTraceRay>> rayFutures = new HashMap<String, WorldObjectFuture<AutoTraceRay>>();
    IWorldView worldView = null;
    IAct act = null;
    String idSuffix = null;
    int counter = 0;
    int alreadyInitialized = 0;
    Flag<Boolean> allRaysInitialized = new Flag((Object)false);
    boolean listening = false;

    public Flag<Boolean> getAllRaysInitialized() {
        return this.allRaysInitialized.getImmutable();
    }

    public Raycasting(AbstractUT2004Bot bot) {
        super((Logger)bot.getLogger().platform());
        this.worldView = bot.getWorldView();
        this.act = bot.getAct();
        this.idSuffix = "_" + bot.getName() + UUID.randomUUID().toString();
    }

    public void clear() throws CommunicationException {
        this.act.act((CommandMessage)new Act("All"));
        this.rayFutures.clear();
        this.allRaysInitialized.setFlag((Object)false);
        this.alreadyInitialized = 0;
        this.listening = false;
    }

    public void endRayInitSequence() {
        this.listening = true;
        this.checkIfAllInited();
    }

    public Future<AutoTraceRay> createRay(String Id, Vector3d Direction, int Length, boolean FastTrace2, boolean FloorCorrection, boolean TraceActors) throws CommunicationException {
        AddRay addRay = new AddRay(Id, Direction, Length, FastTrace2, FloorCorrection, TraceActors);
        WorldObjectFuture<AutoTraceRay> future = new WorldObjectFuture<AutoTraceRay>(this.worldView, Id, AutoTraceRay.class){

            protected void customObjectEncounteredHook(AutoTraceRay obj) {
                ++Raycasting.this.alreadyInitialized;
                Raycasting.this.checkIfAllInited();
            }
        };
        this.rayFutures.put(Id, future);
        this.act.act((CommandMessage)addRay);
        return future;
    }

    public Future<AutoTraceRay> createRay(Vector3d Direction, int Length, boolean FastTrace2, boolean FloorCorrection, boolean TraceActors) throws CommunicationException {
        String id = this.counter++ + this.idSuffix;
        return this.createRay(id, Direction, Length, FastTrace2, FloorCorrection, TraceActors);
    }

    public AutoTraceRay getRay(String rayID) {
        try {
            return (AutoTraceRay)this.rayFutures.get(rayID).get();
        }
        catch (Exception ex) {
            this.log.severe(ex.getMessage());
            return null;
        }
    }

    protected void checkIfAllInited() {
        if (this.listening && this.rayFutures.size() == this.alreadyInitialized) {
            this.allRaysInitialized.setFlag((Object)true);
        }
    }
}

