/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.objects.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.ut2004.agent.module.AgentModule;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.translator.events.MapPointListObtained;
import cz.cuni.amis.utils.maps.HashMapMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Items
extends AgentModule {
    private ItemMaps items = new ItemMaps();
    protected ItemsListener itemsListener;
    protected MapPointsListener mapPointsListener;
    protected AgentInfo agentInfo;
    protected IWorldView worldView;

    public Map<UnrealId, Item> getAllItems() {
        return Collections.unmodifiableMap(this.items.all);
    }

    public Map<UnrealId, Item> getAllItems(ItemType type) {
        return Collections.unmodifiableMap(this.items.allCategories.get((Object)type));
    }

    public Item getItem(UnrealId id) {
        Item item = (Item)this.items.all.get(id);
        if (item == null) {
            item = (Item)this.items.visible.get(id);
        }
        return item;
    }

    public Item getItem(String stringUnrealId) {
        return this.getItem(UnrealId.get(stringUnrealId));
    }

    public Map<UnrealId, Item> getVisibleItems() {
        return Collections.unmodifiableMap(this.items.visible);
    }

    public Map<UnrealId, Item> getVisibleItems(ItemType type) {
        return Collections.unmodifiableMap(this.items.visibleCategories.get((Object)type));
    }

    public Item getVisibleItem(UnrealId id) {
        Item item = (Item)this.items.visible.get(id);
        return item;
    }

    public Item getVisibleItem(String stringUnrealId) {
        return this.getVisibleItem(UnrealId.get(stringUnrealId));
    }

    public Map<UnrealId, Item> getReachableItems() {
        return Collections.unmodifiableMap(this.items.reachable);
    }

    public Map<UnrealId, Item> getReachableItems(ItemType type) {
        return Collections.unmodifiableMap(this.items.reachableCategories.get((Object)type));
    }

    public Item getReachableItem(UnrealId id) {
        Item item = (Item)this.items.reachable.get(id);
        if (item == null && !(item = (Item)this.items.visible.get(id)).isReachable()) {
            return null;
        }
        return item;
    }

    public Item getReachableItem(String stringUnrealId) {
        return this.getReachableItem(UnrealId.get(stringUnrealId));
    }

    public Map<UnrealId, Item> getKnownPickups() {
        return Collections.unmodifiableMap(this.items.known);
    }

    public Map<UnrealId, Item> getKnownPickups(ItemType type) {
        return Collections.unmodifiableMap(this.items.knownCategories.get((Object)type));
    }

    public Item getKnownPickup(UnrealId id) {
        return (Item)this.items.known.get(id);
    }

    public Item getKnownPickup(String stringUnrealId) {
        return this.getKnownPickup(UnrealId.get(stringUnrealId));
    }

    public boolean isPickupSpawned(Item item) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    protected ItemsListener createItemsListener(IWorldView worldView) {
        return new ItemsListener(worldView);
    }

    protected MapPointsListener createMapPointsListener(IWorldView worldView) {
        return new MapPointsListener(worldView);
    }

    public Items(IWorldView worldView, AgentInfo agentInfo, Logger log) {
        super(log);
        this.worldView = worldView;
        this.agentInfo = agentInfo != null ? agentInfo : new AgentInfo(worldView, null, log);
        this.itemsListener = this.createItemsListener(worldView);
        this.mapPointsListener = this.createMapPointsListener(worldView);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MapPointsListener
    implements IWorldEventListener<MapPointListObtained> {
        public MapPointsListener(IWorldView worldView) {
            worldView.addEventListener(MapPointListObtained.class, (IWorldEventListener)this);
        }

        public void notify(MapPointListObtained event) {
            Items.this.items.notify(event.getItems());
            Items.this.worldView.removeEventListener(MapPointListObtained.class, (IWorldEventListener)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ItemsListener
    implements IWorldObjectListener<Item, WorldObjectUpdatedEvent<Item>> {
        public ItemsListener(IWorldView worldView) {
            worldView.addObjectListener(Item.class, WorldObjectUpdatedEvent.class, (IWorldObjectListener)this);
        }

        public void notify(WorldObjectUpdatedEvent<Item> event) {
            Items.this.items.notify((Item)event.getObject());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ItemMaps {
        private HashMap<UnrealId, Item> all = new HashMap();
        private HashMap<UnrealId, Item> visible = new HashMap();
        private HashMap<UnrealId, Item> reachable = new HashMap();
        private HashMap<UnrealId, Item> known = new HashMap();
        private HashMapMap<ItemType, UnrealId, Item> allCategories = new HashMapMap();
        private HashMapMap<ItemType, UnrealId, Item> visibleCategories = new HashMapMap();
        private HashMapMap<ItemType, UnrealId, Item> reachableCategories = new HashMapMap();
        private HashMapMap<ItemType, UnrealId, Item> knownCategories = new HashMapMap();

        private ItemMaps() {
        }

        private void notify(Item item) {
            UnrealId uid = item.getId();
            if (!this.all.containsKey(uid)) {
                this.all.put(uid, item);
                this.allCategories.put((Object)item.getType(), (Object)item.getId(), (Object)item);
            }
            boolean wasVisible = this.visible.containsKey(uid);
            boolean isVisible = item.isVisible();
            if (isVisible && !wasVisible) {
                this.visible.put(uid, item);
                this.visibleCategories.put((Object)item.getType(), (Object)item.getId(), (Object)item);
            } else if (!isVisible && wasVisible) {
                this.visible.remove(uid);
                this.visibleCategories.remove((Object)item.getType(), (Object)item.getId());
            }
            if (!isVisible && item.isDropped()) {
                this.all.remove(uid);
                this.allCategories.remove((Object)item.getType(), (Object)item.getId());
            }
            boolean wasReachable = this.reachable.containsKey(uid);
            boolean isReachable = item.isReachable();
            if (isReachable && !wasReachable) {
                this.reachable.put(uid, item);
                this.reachableCategories.put((Object)item.getType(), (Object)item.getId(), (Object)item);
            } else if (!isReachable && wasReachable) {
                this.reachable.remove(uid);
                this.reachableCategories.remove((Object)item.getType(), (Object)item.getId());
            }
        }

        private void notify(Map<UnrealId, Item> items) {
            this.known.putAll(items);
            for (Item item : items.values()) {
                this.knownCategories.put((Object)item.getType(), (Object)item.getId(), (Object)item);
            }
        }
    }
}

