/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.ut2004.agent.module.AgentModule;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import java.util.logging.Logger;

public class Game
extends AgentModule {
    GameInfo lastGameInfo = null;
    InitedMessage lastInitedMessage = null;
    BeginMessage lastBeginMessage = null;
    GameInfoListener gameInfoListener;
    InitedMessageListener initedMessageListener;
    BeginMessageListener beginMessageListener;

    public GameType getGameType() {
        return GameType.getType(this.lastGameInfo.getGametype());
    }

    public String getMapName() {
        return this.lastGameInfo.getLevel();
    }

    public double getTime() {
        return this.lastBeginMessage.getTime();
    }

    public double getTimeLimit() {
        return this.lastGameInfo.getTimeLimit();
    }

    public double getRemainingTime() {
        return this.getTimeLimit() - this.getTime();
    }

    public int getFragLimit() {
        return this.lastGameInfo.getFragLimit();
    }

    public int getTeamScoreLimit() {
        return (int)this.lastGameInfo.getGoalTeamScore();
    }

    public int getMaxTeams() {
        return this.lastGameInfo.getMaxTeams();
    }

    public int getMaxTeamSize() {
        return this.lastGameInfo.getMaxTeamSize();
    }

    public int getStartHealth() {
        return this.lastInitedMessage.getHealthStart();
    }

    public int getFullHealth() {
        return this.lastInitedMessage.getHealthFull();
    }

    public int getMaxHealth() {
        return this.lastInitedMessage.getHealthMax();
    }

    public int getMaxArmor() {
        return this.lastInitedMessage.getShieldStrengthMax();
    }

    public int getMaxLowArmor() {
        return 50;
    }

    public int getMaxHighArmor() {
        return 100;
    }

    public int getStartAdrenaline() {
        return (int)this.lastInitedMessage.getAdrenalineStart();
    }

    public int getTargetAdrenaline() {
        return (int)this.lastInitedMessage.getAdrenalineMax();
    }

    public int getMaxAdrenaline() {
        return (int)this.lastInitedMessage.getAdrenalineMax();
    }

    public boolean getWeaponsStay() {
        return this.lastGameInfo.isWeaponStay();
    }

    public int getMaxMultiJump() {
        return this.lastInitedMessage.getMaxMultiJump();
    }

    public void getMutators() {
    }

    public boolean isPaused() {
        return this.lastGameInfo.isGamePaused();
    }

    public boolean isBotsPaused() {
        return this.lastGameInfo.isBotsPaused();
    }

    public Game(IWorldView worldView, Logger log) {
        super(log);
        this.gameInfoListener = new GameInfoListener(worldView);
        this.beginMessageListener = new BeginMessageListener(worldView);
        this.initedMessageListener = new InitedMessageListener(worldView);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BeginMessageListener
    implements IWorldEventListener<BeginMessage> {
        public void notify(BeginMessage event) {
            Game.this.lastBeginMessage = event;
        }

        public BeginMessageListener(IWorldView worldView) {
            worldView.addEventListener(BeginMessage.class, (IWorldEventListener)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InitedMessageListener
    implements IWorldEventListener<InitedMessage> {
        public void notify(InitedMessage event) {
            Game.this.lastInitedMessage = event;
        }

        public InitedMessageListener(IWorldView worldView) {
            worldView.addEventListener(InitedMessage.class, (IWorldEventListener)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GameInfoListener
    implements IWorldEventListener<GameInfo> {
        public void notify(GameInfo event) {
            Game.this.lastGameInfo = event;
        }

        public GameInfoListener(IWorldView worldView) {
            worldView.addEventListener(GameInfo.class, (IWorldEventListener)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GameType {
        BotDeathMatch,
        BotTeamGame,
        BotCTFGame,
        BotBombingRun,
        BotDoubleDomination,
        Unknown;


        public static GameType getType(String type) {
            if (type.equals("BotDeathMatch")) {
                return BotDeathMatch;
            }
            if (type.equals("BotTeamGame")) {
                return BotTeamGame;
            }
            if (type.equals("BotCTFGame")) {
                return BotCTFGame;
            }
            if (type.equals("BotBombingRun")) {
                return BotBombingRun;
            }
            if (type.equals("BotDoubleDomination")) {
                return BotDoubleDomination;
            }
            return Unknown;
        }
    }
}

