/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.objects.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Velocity;
import cz.cuni.amis.pogamut.ut2004.agent.module.AgentModule;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerScore;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.TeamScore;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.VolumeChanged;
import java.util.logging.Logger;

public class AgentInfo
extends AgentModule {
    public static final int TEAM_RED = 0;
    public static final int TEAM_BLUE = 1;
    public static final int TEAM_GREEN = 2;
    public static final int TEAM_GOLD = 3;
    public static final int TEAM_NONE = 255;
    public static final double AT_LOCATION_EPSILON = 120.0;
    Self self = null;
    InitedMessage lastInitedMessage = null;
    PlayerScore lastPlayerScore = null;
    TeamScore lastTeamScore = null;
    VolumeChanged lastVolumeChanged = null;
    private InitedMessageListener initedMessageListener;
    private PlayerScoreListener playerScoreListener;
    private VolumeChangedListener volumeChangedListener;
    private SelfListener selfListener;
    protected Game game;

    public UnrealId getId() {
        return this.self.getId();
    }

    public String getName() {
        return this.self.getName();
    }

    public int getTeam() {
        return this.self.getTeam();
    }

    public boolean isEnemy(int team) {
        return team == 255 || team != this.getTeam();
    }

    public boolean isEnemy(Player player) {
        return this.isEnemy(player.getTeam());
    }

    public boolean isFriend(int team) {
        return team == this.getTeam();
    }

    public boolean isFriend(Player player) {
        return this.isFriend(player.getTeam());
    }

    public Location getLocation() {
        return this.self.getLocation();
    }

    public boolean atLocation(Location location) {
        return this.atLocation(location, 120.0);
    }

    public boolean atLocation(Location location, double epsilon) {
        if (location == null) {
            return false;
        }
        return this.getLocation().getPoint3d().distance(location.getPoint3d()) < epsilon;
    }

    public double getDistance(Location location) {
        return this.self.getLocation().getDistance(location);
    }

    public Rotation getRotation() {
        return this.self.getRotation();
    }

    public Velocity getVelocity() {
        return this.self.getVelocity();
    }

    public boolean isMoving() {
        return !this.getVelocity().isZero();
    }

    public boolean isCrouched() {
        return this.self.isCrouched();
    }

    public boolean isWalking() {
        return this.self.isWalking();
    }

    public Location getFloorLocation() {
        return this.self.getFloorLocation();
    }

    public boolean isTouchingGround() {
        return this.getLocation().z - this.getFloorLocation().z < (double)(this.isCrouched() ? 50 : 80);
    }

    public double getRemainingUDamageTime() {
        return this.self.getUDamageTime() - this.self.getLastSeenTime();
    }

    public boolean hasUDamage() {
        return this.getRemainingUDamageTime() > 0.0;
    }

    public boolean hasInvisibility() {
        return this.self.getCombo().equals("xGame.ComboInvis");
    }

    public boolean hasFastFire() {
        return this.self.getCombo().equals("xGame.ComboBerserk");
    }

    public boolean hasRegeneration() {
        return this.self.getCombo().equals("xGame.ComboDefensive");
    }

    public boolean hasSpeed() {
        return this.self.getCombo().equals("xGame.ComboSpeed");
    }

    public int getHealth() {
        return this.self.getHealth();
    }

    public boolean isHealthy() {
        return this.getHealth() >= this.game.getFullHealth();
    }

    public boolean isSuperHealthy() {
        return this.getHealth() >= this.game.getMaxHealth();
    }

    public int getArmor() {
        return this.self.getArmor();
    }

    public boolean hasArmor() {
        return this.getArmor() >= this.game.getMaxArmor();
    }

    public int getLowArmor() {
        return this.self.getSmallArmor();
    }

    public boolean hasLowArmor() {
        return this.getLowArmor() >= this.game.getMaxLowArmor();
    }

    public int getHighArmor() {
        return this.self.getArmor() - this.self.getSmallArmor();
    }

    public boolean hasHighArmor() {
        return this.getHighArmor() >= this.game.getMaxHighArmor();
    }

    public int getAdrenaline() {
        return this.self.getAdrenaline();
    }

    public boolean isAdrenalineSufficient() {
        return this.getAdrenaline() >= this.game.getTargetAdrenaline();
    }

    public boolean isAdrenalineFull() {
        return this.getAdrenaline() >= this.game.getMaxAdrenaline();
    }

    public UnrealId getCurrentWeapon() {
        return this.self.getWeapon();
    }

    public int getCurrentAmmo() {
        return this.self.getPrimaryAmmo();
    }

    public int getCurrentAlternateAmmo() {
        return this.self.getSecondaryAmmo();
    }

    public boolean isShooting() {
        return this.self.isShooting();
    }

    public boolean isPrimaryShooting() {
        return this.isShooting() && !this.isAlternateShooting();
    }

    public boolean isAlternateShooting() {
        return this.self.isAltFiring();
    }

    public int getKills() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public int getDeaths() {
        return this.lastPlayerScore.getDeaths();
    }

    public int getSuicides() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public int getScore() {
        return this.lastPlayerScore.getScore();
    }

    public int getTeamScore() {
        return this.lastTeamScore.getScore();
    }

    public Velocity getCurrentZoneVelocity() {
        return this.lastVolumeChanged.getZoneVelocity();
    }

    public Velocity getCurrentZoneGravity() {
        return this.lastVolumeChanged.getZoneGravity();
    }

    public double getCurrentVolumeGroundFriction() {
        return this.lastVolumeChanged.getGroundFriction();
    }

    public double getCurrentVolumeFluidFriction() {
        return this.lastVolumeChanged.getFluidFriction();
    }

    public double _getCurrentVolumeTerminalVelocity() {
        return this.lastVolumeChanged.getTerminalVelocity();
    }

    public boolean isCurrentVolumeWater() {
        return this.lastVolumeChanged.isWaterVolume();
    }

    public boolean isCurrentVolumePainCausing() {
        return this.lastVolumeChanged.isPainCausing();
    }

    public double getCurrentVolumeDamagePerSec() {
        return this.lastVolumeChanged.getDamagePerSec();
    }

    public boolean isCurrentVolumeDestructive() {
        return this.lastVolumeChanged.isDestructive();
    }

    public String getCurrentVolumeDamageType() {
        return this.lastVolumeChanged.getDamageType();
    }

    public boolean isCurrentVolumeBanningInventory() {
        return this.lastVolumeChanged.isNoInventory();
    }

    public boolean isCurrentVolumeAffectingProjectiles() {
        return this.lastVolumeChanged.isMoveProjectiles();
    }

    public boolean isCurrentZoneNeutral() {
        return this.lastVolumeChanged.isNeutralZone();
    }

    public double getDamageScaling() {
        return this.lastInitedMessage.getDamageScaling();
    }

    public double getBaseSpeed() {
        return this.lastInitedMessage.getGroundSpeed();
    }

    public double getAirSpeed() {
        return this.lastInitedMessage.getAirSpeed();
    }

    public double getLadderSpeed() {
        return this.lastInitedMessage.getLadderSpeed();
    }

    public double getWaterSpeed() {
        return this.lastInitedMessage.getWaterSpeed();
    }

    public double getFallSpeed() {
        return this.lastInitedMessage.getMaxFallSpeed();
    }

    public double getDodgeSpeedFactor() {
        return this.lastInitedMessage.getDodgeSpeedFactor();
    }

    public double getAccelerationRate() {
        return this.lastInitedMessage.getAccelRate();
    }

    public double getAirControl() {
        return this.lastInitedMessage.getAirControl();
    }

    public double getJumpZBoost() {
        return this.lastInitedMessage.getJumpZ();
    }

    public double getDodgeZBoost() {
        return this.lastInitedMessage.getDodgeSpeedZ();
    }

    protected double getTime() {
        return this.game.getTime();
    }

    public Self getSelf() {
        return this.self;
    }

    public AgentInfo(IWorldView worldView, Game game, Logger log) {
        super(log);
        this.game = game != null ? game : new Game(worldView, log);
        this.selfListener = new SelfListener(worldView);
        this.initedMessageListener = new InitedMessageListener(worldView);
        this.playerScoreListener = new PlayerScoreListener(worldView);
        this.volumeChangedListener = new VolumeChangedListener(worldView);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelfListener
    implements IWorldObjectListener<Self, WorldObjectFirstEncounteredEvent<Self>> {
        private IWorldView worldView;

        public SelfListener(IWorldView worldView) {
            worldView.addObjectListener(Self.class, WorldObjectFirstEncounteredEvent.class, (IWorldObjectListener)this);
            this.worldView = worldView;
        }

        public void notify(WorldObjectFirstEncounteredEvent<Self> event) {
            AgentInfo.this.self = (Self)event.getObject();
            this.worldView.removeObjectListener(Self.class, WorldObjectFirstEncounteredEvent.class, (IWorldObjectListener)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VolumeChangedListener
    implements IWorldEventListener<VolumeChanged> {
        public void notify(VolumeChanged event) {
            AgentInfo.this.lastVolumeChanged = event;
        }

        public VolumeChangedListener(IWorldView worldView) {
            worldView.addEventListener(VolumeChanged.class, (IWorldEventListener)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PlayerScoreListener
    implements IWorldEventListener<PlayerScore> {
        public void notify(PlayerScore event) {
            AgentInfo.this.lastPlayerScore = event;
        }

        public PlayerScoreListener(IWorldView worldView) {
            worldView.addEventListener(PlayerScore.class, (IWorldEventListener)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InitedMessageListener
    implements IWorldEventListener<InitedMessage> {
        public void notify(InitedMessage event) {
            AgentInfo.this.lastInitedMessage = event;
        }

        public InitedMessageListener(IWorldView worldView) {
            worldView.addEventListener(InitedMessage.class, (IWorldEventListener)this);
        }
    }
}

